package com.spring.boxes.dollar;

import org.apache.commons.lang3.ArrayUtils;
import org.hashids.Hashids;

import com.google.common.base.Preconditions;

// https://akarin.dev/2021/02/26/hashids-description/
public class HashUtils {

    public static final int LEN_DEF = 19;
    public static final String SALT_DEF = "boxes";
    public static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890abcdefghijklmnopqrstuvwxyz";
    public static final Hashids HASHIDS = new Hashids(SALT_DEF, LEN_DEF, ALPHABET);

    public static String nanoTime() {
        return HASHIDS.encode(System.nanoTime());
    }

    public static String encode(long source) {
        return HASHIDS.encode(source);
    }

    public static long decode(String source) {
        long[] arr = HASHIDS.decode(source);
        Preconditions.checkArgument(ArrayUtils.getLength(arr) == 1, "格式错误");
        return arr[0];
    }

    public static String encodeHex(String source) {
        return HASHIDS.encodeHex(source);
    }

    public static String decodeHex(String source) {
        return HASHIDS.decodeHex(source);
    }

    public static Hashids instance() {
        return instance(LEN_DEF);
    }

    public static Hashids instance(int minHashLength) {
        return instance(SALT_DEF, minHashLength, ALPHABET);
    }

    public static Hashids instance(String salt, int minHashLength) {
        return instance(salt, minHashLength, ALPHABET);
    }

    public static Hashids instance(String salt, int minHashLength, String alphabet) {
        return new Hashids(salt, minHashLength, alphabet);
    }

}
