package com.spring.boxes.dollar;

import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import com.spring.boxes.dollar.term.Endpoint;
import com.spring.boxes.dollar.term.HttpPoint;
import com.spring.boxes.dollar.term.RatePair;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;

@Slf4j
public class HttpUtils {

    // 协议HTTP
    public static final String HTTP = "http://";

    // 协议HTTPS
    public static final String HTTPS = "https://";

    @Deprecated
    public static boolean isHttpUrl(String url) {
        return Endpoint.isHttp(url);
    }

    @Deprecated
    public static boolean isHttpsUrl(String url) {
        return Endpoint.isHttps(url);
    }

    @Deprecated
    public static boolean isHttpOrHttpsUrl(String url) {
        return Endpoint.isHttpOrHttps(url);
    }

    /**
     * 带权重获取域名
     *
     * @param weights 域名权重集
     * @return 权重结果
     */
    @Deprecated
    public static String getHttpPoint(List<RatePair<String>> weights) {
        return Endpoint.getEndpoint(weights);
    }

    /**
     * 将地址转换成Https
     *
     * @param url 原始Url
     * @return 替换后的目标地址(HTTPS)
     */
    @Deprecated
    public static String getHttpsUrl(String url) {
        return Endpoint.toHttps(url);
    }

    /**
     * 将地址转换为HTTP地址
     *
     * @param url 原始地址
     * @return 替换后的目标地址(HTTP)
     */
    @Deprecated
    public static String getHttpUrl(String url) {
        return Endpoint.toHttps(url);
    }

    /**
     * 权重策略替换域名地址
     *
     * @param config 权重策略
     * @param url    原始地址
     * @return 替换后的目标地址
     */
    public static String getTargetUrl(HttpPoint config, String url) {
        if (!HttpUtils.isHttpOrHttpsUrl(url)) {
            return url;
        }
        if (Objects.isNull(config) || StringUtils.isBlank(config.getScheme())) {
            throw new IllegalArgumentException("域名参数配置错误");
        }
        String protocol = config.getScheme();
        List<String> accept = ListUtils.emptyIfNull(config.getAccept());
        List<RatePair<String>> target = ListUtils.emptyIfNull(config.getTarget());
        try {
            URI urlObj = new URI(url);
            String schema = urlObj.getScheme();
            String host = urlObj.getHost();
            String path = urlObj.getPath();
            if (!StringUtils.isEmpty(protocol)) {
                schema = protocol;
            }
            if (accept.contains(host)) {
                host = getHttpPoint(target);
            }
            return schema + "://" + host + path;
        } catch (Throwable e) {
            return url;
        }
    }

}
