package com.spring.boxes.dollar;


import com.google.common.collect.Lists;
import org.apache.commons.collections4.ListUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class JoiningUtils {

    public static <E> String joinArray(E... es) {
        return joinArray(StringUtils.COMMA, es);
    }

    public static <E> String joinArray(String split, E... es) {
        Objects.requireNonNull(es, "args es is null.");
        List<E> list = Arrays.stream(es).collect(Collectors.toList());
        return joinList(list, split);
    }

    public static <T> String joinList(List<T> coll) {
        return joinList(coll, StringUtils.COMMA);
    }

    public static <T> String joinList(List<T> coll, String split) {
        return ListUtils.emptyIfNull(coll).stream().map(String::valueOf).collect(Collectors.joining(split));
    }

    public static List<Long> asLongList(String source) {
        return asLongList(source, null);
    }

    public static List<Long> asLongList(String source, String split) {
        return asList(source, getSplit(split), Long::parseLong);
    }

    public static List<Short> asShortList(String source) {
        return asShortList(source, null);
    }

    public static List<Short> asShortList(String source, String split) {
        return asList(source, getSplit(split), Short::parseShort);
    }

    public static List<Integer> asIntegerList(String source) {
        return asIntegerList(source, null);
    }

    public static List<Integer> asIntegerList(String source, String split) {
        return asList(source, getSplit(split), Integer::parseInt);
    }

    public static List<Float> asFloatList(String source) {
        return asFloatList(source, null);
    }

    public static List<Float> asFloatList(String source, String split) {
        return asList(source, getSplit(split), Float::parseFloat);
    }

    public static List<Double> asDoubleList(String source) {
        return asDoubleList(source, null);
    }

    public static List<Double> asDoubleList(String source, String split) {
        return asList(source, getSplit(split), Double::parseDouble);
    }

    public static List<String> asStringList(String source) {
        return asStringList(source, null);
    }

    public static List<String> asStringList(String source, String split) {
        return asList(source, getSplit(split), String::toString);
    }

    public static String getSplit(String split) {
        return StringUtils.isBlank(split) ? StringUtils.COMMA : split;
    }

    public static <R> List<R> asList(String source, String split, Function<String, ? extends R> mapper) {
        if (StringUtils.isBlank(source)) {
            return Lists.newArrayList();
        }
        return Arrays.stream(source.split(split)).filter(StringUtils::isNotBlank).peek(StringUtils::trim).map(mapper).distinct().collect(Collectors.toList());
    }
}
