package com.spring.boxes.dollar;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;

import lombok.experimental.UtilityClass;

@UtilityClass
public class MoneyUtils {

    private final BigDecimal DIVISOR = new BigDecimal(100);

    // 把long型，单位 分 的金额转成string，最多2位小数，如6666 -> "66.66", 6660 -> "66.6", 6600 -> "66"
    public String convertFenToYuan(long fen) {
        return new BigDecimal(fen).divide(DIVISOR, 2, RoundingMode.CEILING)
                .stripTrailingZeros().toPlainString();
    }

    public static String moneyFormat(long money){
        return moneyFormat(Locale.CHINA, money);
    }

    public static String moneyFormat(Locale locale, long money){
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(Locale.CHINA);
        return numberFormat.format(money);
    }

    /**
    public static void main(String[] args) {
        System.out.println(moneyFormat(12005));
    }*/
}
