package com.spring.boxes.dollar;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.term.RatePair;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;

import java.util.Collections;
import java.util.List;

@Slf4j
public class RateUtils {

    public static void main(String[] args) {
        List<RatePair<String>> list = Lists.newArrayList();
        list.add(new RatePair<>(1, "10001L"));
        list.add(new RatePair<>(2, "10002L"));
        list.add(new RatePair<>(3, "10003L"));
        list.add(new RatePair<>(4, "10004L"));
        list.add(new RatePair<>(90, "10005L"));
        System.out.println(getRatePair(list));
    }

    /**
     * <a href="https://www.cnblogs.com/softidea/p/10002359.html">抽奖权重</a>
     *
     * @param list 带权数据集合
     * @param <T>  泛型参数
     * @return 概率场景下的命中结果
     */
    public static <T> RatePair<T> getRatePair(List<RatePair<T>> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new IllegalArgumentException("权重集合为空");
        }
        // 计算总概率，用来保证总概率不一定是1
        double sumRate = list.stream().mapToDouble(RatePair::getRate).sum();
        log.info("[事件概率]总概率:{}", sumRate);
        List<Double> sortRates = Lists.newArrayListWithCapacity(list.size() + 1);
        double tempRate = 0d;
        // 遍历概率集合，计算每个奖品的中奖区间
        for (RatePair<T> idWeight : list) {
            tempRate += idWeight.getRate();
            sortRates.add(tempRate / sumRate);
        }
        // 根据区块值来获取抽取到的物品索引
        double nextRate = Math.random();
        sortRates.add(nextRate);
        Collections.sort(sortRates);
        log.info("[事件概率]概率集:{}", sortRates);
        return list.get(sortRates.indexOf(nextRate));
    }


    /**
     * 带权重随机
     *
     * @param rates 权重值
     * @return 索引编号
     */
    public static int getRateIndex(List<Integer> rates) {
        int total = rates.stream().mapToInt(Integer::intValue).sum();
        if(total == 0){
            return 0;
        }
        int random = RandomUtils.nextInt(0, total);
        int offset = 0;
        for (int i = 0; i < rates.size(); i++) {
            int rate = rates.get(i);
            if (random >= offset && random < offset + rate) {
                return i;
            }
            offset += rate;
        }
        return rates.size() - 1;
    }

}
