package com.spring.boxes.dollar;

import org.apache.commons.lang3.StringUtils;

import java.util.regex.Pattern;

public class RegexUtils {

    /**
     * 验证数据
     */
    public static final String NUMBER = "^[0-9]*$";

    /**
     * 用户名
     */
    public static final String USER_NAME = "^[a-zA-Z\\u4E00-\\u9FA5][a-zA-Z0-9_\\u4E00-\\u9FA5]{1,11}$";

    /**
     * 密码
     */
    public static final String USER_PASSWORD = "^.{6,32}$";

    /**
     * 邮箱
     */
    public static final String EMAIL = "^[A-Za-z0-9\\u4e00-\\u9fa5]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$";

    /**
     * 手机号
     */
    public static final String PHONE = "^1[3-9]\\d{9}$";

    /**
     * 手机号或者邮箱
     */
    public static final String EMAIL_OR_PHONE = EMAIL + "|" + PHONE;

    /**
     * URL路径
     */
    public static final String URL = "^(https?:\\/\\/)?([\\da-z\\.-]+)\\.([a-z\\.]{2,6})(:[\\d]+)?([\\/\\w\\.-]*)*\\/?$";

    /**
     * 身份证校验，初级校验，具体规则有一套算法
     */
    public static final String ID_CARD = "^\\d{15}$|^\\d{17}([0-9]|X)$";

    /**
     * 域名校验
     */
    public static final String DOMAIN = "^[0-9a-zA-Z]+[0-9a-zA-Z\\.-]*\\.[a-zA-Z]{2,4}$";

    /**
     * 大陆手机号码
     */
    public static final String CHN_PHONE = "^[1][3-8]\\d{9}$";

    /**
     * 港澳手机号
     */
    public static final String HK_OR_MO_PHONE = "^(([6|9])\\d{7})|([86]([8|6])\\d{5})$";

    /**
     * 台湾手机号码
     */
    public static final String TW_PHONE = "^[0][9]\\d{8}$";

    /**
     * 座机号码
     */
    public static final String TELEPHONE = "^((0\\d{2,3})-?)(\\d{7,8})(-?(\\d{3,}))?$";

    /**
     * 正则表达式匹配中文
     */
    public final static String RE_CHINESE = "[\u4E00-\u9FFF]";

    /**
     * 英文字母 、数字和下划线
     */
    public final static Pattern GENERAL = Pattern.compile("^\\w+$");

    /**
     * 邮编
     */
    public final static Pattern ZIP_CODE = Pattern.compile("\\d{6}");

    /**
     * 判断该字符串是否是IPV4地址
     *
     * @param ip IP地址
     * @return 是否是IPV4
     */
    public static boolean isIpv4(String ip) {
        if (StringUtils.isBlank(ip)) {
            return false;
        }
        String regex = "\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b";
        return Pattern.matches(regex, ip);
    }

    @Deprecated
    public static boolean isMatch(String source, String regex) {
        return Pattern.matches(regex, source);
    }
}
