package com.spring.boxes.dollar;

import com.jcraft.jsch.*;
import lombok.extern.slf4j.Slf4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.util.Properties;
import java.util.Vector;

@Slf4j
public class SftpUtils {

    public static ChannelSftp connect(String host, int port, String username, String password) {
        ChannelSftp sftp = null;
        try {
            JSch jsch = new JSch();
            jsch.getSession(username, host, port);
            Session sshSession = jsch.getSession(username, host, port);
            sshSession.setPassword(password);

            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            sshSession.setConfig(sshConfig);
            sshSession.connect();

            Channel channel = sshSession.openChannel("sftp");
            channel.connect();
            sftp = (ChannelSftp) channel;
        } catch (JSchException e) {
            log.error("连接Sftp服务器失败,请确认ftp连接参数是否设置正确", e);
        }
        return sftp;
    }

    public static void disconnect(ChannelSftp sftp) {
        if (null != sftp) {
            if (sftp.isConnected()) {
                sftp.disconnect();
            }
            sftp.quit();
            try {
                Session session = sftp.getSession();
                if (session.isConnected())
                    session.disconnect();
            } catch (JSchException e) {
                log.error("从sftp获取session失败", e);
            }
        }
    }

    public static void upload(String directory, String uploadFile, String saveFile, ChannelSftp sftp) {
        upload(directory, new File(uploadFile), saveFile, sftp);
    }

    public static void upload(String directory, File file, String saveFile, ChannelSftp sftp) {
        try {
            sftp.cd(directory);
            if ((saveFile != null) && (saveFile.length() > 0))
                sftp.put(Files.newInputStream(file.toPath()), saveFile);
            else
                sftp.put(Files.newInputStream(file.toPath()), file.getName());
        } catch (Exception e) {
            log.error("upload has error", e);
        }
    }

    public void download(String directory, String downloadFile, String saveFile, ChannelSftp sftp) {
        try {
            sftp.cd(directory);
            File file = new File(saveFile);
            sftp.get(downloadFile, Files.newOutputStream(file.toPath()));
        } catch (Exception e) {
            log.error("download has error", e);
        }
    }

    public void delete(String directory, String deleteFile, ChannelSftp sftp) {
        try {
            sftp.cd(directory);
            sftp.rm(deleteFile);
        } catch (Exception e) {
            log.error("delete has error", e);
        }
    }

    public Vector listFiles(String directory, ChannelSftp sftp) throws SftpException {
        return sftp.ls(directory);
    }
}
