package com.spring.boxes.dollar;

import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.RandomStringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.ThreadLocalRandom;

import com.google.common.base.Throwables;
import org.apache.commons.text.StringSubstitutor;

import static org.apache.commons.text.StringSubstitutor.DEFAULT_VAR_START;

// https://any86.github.io/any-rule/
public class StringUtils {

    public static final String EMPTY = "";
    public static final String COMMA = ",";
    public static final String ZERO = "0";
    public static final long _10_000 = 10_000; // 1万
    public static final long _100_000_000 = 100_000_000; // 1亿

    public static boolean isNotBlank(CharSequence cs) {
        return org.apache.commons.lang3.StringUtils.isNotBlank(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        return org.apache.commons.lang3.StringUtils.isBlank(cs);
    }

    public static String trimToEmpty(String str){
        return org.apache.commons.lang3.StringUtils.trimToEmpty(str);
    }

    public static String randomAlphanumeric(int size) {
        return RandomStringUtils.random(size, 0, 0, true, true, null, ThreadLocalRandom.current());
    }

    public static String substitutor(String source, Map<String, Object> valueMap) {
        StringSubstitutor stringSubstitutor = new StringSubstitutor(valueMap, DEFAULT_VAR_START, StringSubstitutor.DEFAULT_VAR_END);
        return stringSubstitutor.replace(source);
    }

    /**
     * 全角字符到半角字符转换
     * 只处理全角的空格，全角！到全角～之间的字符，忽略其他
     *
     * @param source 原文本
     * @return 转换后的文本
     */
    public static String toDBC(String source) {
        return DSBCUtils.toDBC(source);
    }


    /**
     * 半角字符到全角字符转换
     * 只处理空格，!到˜之间的字符，忽略其他
     *
     * @param source 原文本
     * @return 转换后的文本
     */
    public static String toSBC(String source) {
        return DSBCUtils.toSBC(source);
    }

    /**
     * 抽取文本话题信息
     * 输入: "ABC#话题#话题内容#话题内容" 输出: 话题
     * 输入: "ABC#话题" 输出:
     *
     * @param source 提交内容
     * @return 话题标题
     */
    public static String getPoundSubject(String source) {
        return Optional.ofNullable(DSBCUtils.toDBC(source)).map(e -> {
            int low = -1;
            int top = -1;
            for (int i = 0; i < e.length(); i++) {
                if (Objects.equals('#', e.charAt(i)) && low == -1) {
                    low = i;
                } else if (Objects.equals('#', e.charAt(i))) {
                    top = i;
                    break;
                }
            }
            if (low < top && 0 != top) {
                return e.substring(low + 1, top);
            }
            return org.apache.commons.lang3.StringUtils.EMPTY;
        }).orElse(org.apache.commons.lang3.StringUtils.EMPTY);
    }

    /**
     * 抽取文本话题信息
     * 输入: "ABC#话题#话题内容#话题内容" 输出: 话题内容#话题内容
     * 输入: "ABC#话题" 输出:
     *
     * @param source 提交内容
     * @return 话题标题
     */
    public static String getPoundContent(String source) {
        String subject = getPoundSubject(source);
        if (org.apache.commons.lang3.StringUtils.isBlank(subject)) {
            return org.apache.commons.lang3.StringUtils.trimToEmpty(source);
        }
        return source.substring(subject.length() + 2);
    }


    public static String trim(String str) {
        return org.apache.commons.lang3.StringUtils.trim(str);
    }

    /**
     * 判断是否中文字符
     *
     * @param c 判断是否中文字符
     * @return 是否中文字符
     */
    public static boolean isChinese(char c) {
        Character.UnicodeScript sc = Character.UnicodeScript.of(c);
        if (sc == Character.UnicodeScript.HAN) {
            return true;
        }
        return false;
    }

    /**
     * 判断是否包含中文字符
     *
     * @param code 判断是否中文字符
     * @return 是否中文字符
     */
    public static boolean isChinese(String code) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank(code)) {
            for (char codeBit : code.toCharArray()) {
                return isChinese(codeBit);
            }
        }
        return false;
    }

    public static String getWatchText(long count) {
        // 小于1w，展示数字
        if (count < _10_000) {
            return String.valueOf(count);
        }
        // 1亿以上显示x.yz亿
        if (count >= _100_000_000) {
            return cellingScale(count, _100_000_000, 2) + "亿";
        }
        // 其余展示x.yw
        return cellingScale(count, _10_000, 1) + "w";
    }

    private static double cellingScale(long left, long right, int scale) {
        return BigDecimal.valueOf(left).divide(
                BigDecimal.valueOf(right), scale, RoundingMode.CEILING).doubleValue();
    }

    public static String uuidSalt() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String getExceptionName(Throwable e) {
        Throwable rootCause = Throwables.getRootCause(e);
        return ClassUtils.getShortClassName(rootCause, org.apache.commons.lang3.StringUtils.EMPTY);
    }

    public static void main(String[] args) {
        for(int i = 0; i < 10; i++){
            System.out.println(randomAlphanumeric(16));
        }
    }
}
