package com.spring.boxes.dollar;

import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.lang.management.ManagementFactory;

@Slf4j
public class SystemUtils {

    public static String getTmpDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static void openDir(String outputDir) {
        try {
            String osName = System.getProperty("os.name");
            if (osName != null) {
                if (osName.contains("Mac")) {
                    Runtime.getRuntime().exec("open " + outputDir);
                } else if (osName.contains("Windows")) {
                    Runtime.getRuntime().exec("cmd /c start " + outputDir);
                } else {
                    log.debug("outputDir:" + outputDir);
                }
            }
        } catch (IOException e) {
            log.error(e.getLocalizedMessage(), e);
        }
    }

    public static int getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        return Integer.parseInt(name.split("@")[0]);
    }

}
