package com.spring.boxes.dollar;

import lombok.extern.slf4j.Slf4j;

import java.util.Timer;
import java.util.TimerTask;

@Slf4j
public class TaskUtils extends Timer {

    public TaskUtils(boolean isDaemon) {
        //daemon进程
        super(true);
    }

    /**
     * 实例化一个新对象
     *
     * @param isDaemon 是否守护进程
     * @return 任务调度对象
     */
    public static TaskUtils newInstance(boolean isDaemon) {
        return new TaskUtils(isDaemon);
    }

    /**
     * 开始任务计划
     *
     * @param timerTask 定时任务对象
     * @param delay     从启动起等待的时间，毫秒
     * @param period    任务运行间隔的时间，毫秒
     */
    public void schedule(TimerTask timerTask, long delay, long period) {
        super.scheduleAtFixedRate(timerTask, delay, period);
        log.info("任务将于 " + delay / 1000 + " 秒后启动，启动间隔时间为 " + period / 1000 + " 秒");
    }
}
