package com.spring.boxes.dollar;

import java.util.Optional;

public class ValueUtils {

    public static char val(Character source) {
        return val(source, (char) 0);
    }

    public static char val(Character source, char defaultVal) {
        return Optional.ofNullable(source).map(x -> x.charValue()).orElse(defaultVal);
    }

    public static float val(Float source) {
        return val(source, 0.0F);
    }

    public static float val(Float source, float defaultVal) {
        return Optional.ofNullable(source).map(x -> x.floatValue()).orElse(defaultVal);
    }

    public static double val(Double source) {
        return val(source, 0.0D);
    }

    public static double val(Double source, double defaultVal) {
        return Optional.ofNullable(source).map(x -> x.doubleValue()).orElse(defaultVal);
    }

    public static byte val(Byte source) {
        return val(source, (byte) 0);
    }

    public static byte val(Byte source, byte defaultVal) {
        return Optional.ofNullable(source).map(x -> x.byteValue()).orElse(defaultVal);
    }

    public static int val(Integer source) {
        return val(source, 0);
    }

    public static int val(Integer source, int defaultVal) {
        return Optional.ofNullable(source).map(x -> x.intValue()).orElse(defaultVal);
    }

    public static boolean val(Boolean source) {
        return val(source, false);
    }

    public static boolean val(Boolean source, boolean defaultVal) {
        return Optional.ofNullable(source).map(x -> x.booleanValue()).orElse(defaultVal);
    }

    public static long val(Long source) {
        return val(source, 0L);
    }

    public static long val(Long source, long defaultVal) {
        return Optional.ofNullable(source).map(x -> x.longValue()).orElse(defaultVal);
    }

    public static String val(String source) {
        return val(source, StringUtils.EMPTY);
    }

    public static String val(String source, String defaultVal) {
        return Optional.ofNullable(source).map(StringUtils::trimToEmpty).orElse(defaultVal);
    }
}
