package com.spring.boxes.dollar.enums;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

@Slf4j
@AllArgsConstructor
public enum ActivityStateEnum implements EnumType {

    OFFLINE(1, "已下线"),
    READIED(3, "待开始"),
    ONGOING(5, "进行中"),
    FINISHED(7, "已结束");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @NoArgsConstructor
    public static class Opt extends EnumWrap<ActivityStateEnum> {

        public List<ActivityStateEnum> valueList() {
            return Lists.newArrayList(ActivityStateEnum.values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();

            private SingleHold() {
            }
        }
    }


}
