package com.spring.boxes.dollar.enums;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

@Slf4j
@AllArgsConstructor
public enum ActivityTypeEnum implements EnumType {

    VENUES(1, "页面会场"),
    COUPON(3, "红包活动"),
    PUNCH(4, "签到活动"),
    INTEGRAL(5, "积分活动"),
    LOTTERY(7, "抽奖活动"),
    FISSION(9, "裂变活动"),
    MISSION(11, "任务活动");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @NoArgsConstructor
    public static class Opt extends EnumWrap<ActivityTypeEnum> {

        public List<ActivityTypeEnum> valueList() {
            return Lists.newArrayList(ActivityTypeEnum.values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();

            private SingleHold() {
            }
        }
    }

}
