package com.spring.boxes.dollar.enums;

import java.util.List;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Getter;

// 账号类型
@Getter
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public enum AmountTypeEnum implements EnumType {
    WALLET(1, "钱包账号");

    private final int value;
    private final String label;

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name();
    }

    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<AmountTypeEnum> {
        public Opt() {

        }

        public List<AmountTypeEnum> valueList() {
            return Lists.newArrayList(AmountTypeEnum.values());
        }

        public static Opt INSTANCE() {
            return AmountTypeEnum.Opt.SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();

            private SingleHold() {
            }
        }
    }
}
