package com.spring.boxes.dollar.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 申请状态
 */
@Getter
@AllArgsConstructor
public enum ApplyStateEnum implements EnumType {

    /**
     * 无
     */
    NONE(0, "无"),
    /**
     * 同意
     */
    AGREE(1, "同意"),
    /**
     * 拒绝
     */
    REFUSED(2, "拒绝"),
    /**
     * 忽略
     */
    IGNORE(3, "忽略");

    @EnumValue
    @JsonValue
    private final Integer value;

    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @NoArgsConstructor
    public static class Opt extends EnumWrap<ApplyStateEnum> {

        public List<ApplyStateEnum> valueList() {
            return Lists.newArrayList(ApplyStateEnum.values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {

            public static Opt opt = new Opt();

            private SingleHold() { }
        }
    }
}
