package com.spring.boxes.dollar.enums;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

@Getter
@AllArgsConstructor
public enum AuditTypeEnum implements EnumType {

    PERSON(1, "用户信息审核"),
    MOMENT(3, "动态信息审核"),
    DATUM(5, "资讯信息审核"),
    PLATE(7, "话题信息审核"),
    RECRUIT(9, "职位信息审核");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<AuditTypeEnum> {

        public Opt() { }

        public List<AuditTypeEnum> valueList() {
            return Lists.newArrayList(AuditTypeEnum.values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();

            private SingleHold() {

            }
        }
    }
}
