package com.spring.boxes.dollar.enums;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;

import java.util.List;

@AllArgsConstructor
public enum CategoryTypeEnum implements EnumType {

    DATUM(1, "资讯分类"),
    ARTICLE(3, "文章分类"),
    PRODUCT(5, "商品分类"),
    PRESENT(7, "虚拟礼品");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<CategoryTypeEnum> {

        public List<CategoryTypeEnum> valueList() {
            return Lists.newArrayList(CategoryTypeEnum.values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();
        }
    }
}
