package com.spring.boxes.dollar.enums;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

@Getter
@AllArgsConstructor
public enum ChatTypeEnum implements EnumType {

    SINGLE(1, "单人聊天"), GROUP(2, "群组聊天");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<ChatTypeEnum> {

        @Override
        public List<ChatTypeEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static ChatTypeEnum.Opt INSTANCE() {
            return ChatTypeEnum.Opt.SingleHold.opt;
        }

        private static class SingleHold {
            public static ChatTypeEnum.Opt opt = new ChatTypeEnum.Opt();
        }
    }
}
