package com.spring.boxes.dollar.enums;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;

import java.util.List;

@AllArgsConstructor
public enum DataWayEnum implements EnumType {

    STATIC(1, "静态获取"),
    DYNAMIC(3, "动态获取");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<DataWayEnum> {

        @Override
        public List<DataWayEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static DataWayEnum.Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static DataWayEnum.Opt opt = new DataWayEnum.Opt();
        }
    }
}
