package com.spring.boxes.dollar.enums;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;

import java.util.List;

@AllArgsConstructor
public enum DaysTypeEnum implements EnumType {

    DAY_1(1, "1天"), DAY_3(1, "3天"), DAY_5(7, "7天"), DAY_30(30, "30天");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<DaysTypeEnum> {

        public List<DaysTypeEnum> valueList() {
            return Lists.newArrayList(DaysTypeEnum.values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();
        }
    }
}
