package com.spring.boxes.dollar.enums;


import com.spring.boxes.dollar.support.EnumType;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum DefaultEnum implements EnumType {

    IGNORE(-1, "忽略/全部");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

}
