package com.spring.boxes.dollar.enums;

import java.util.List;

import com.baomidou.mybatisplus.annotation.IEnum;
import com.google.common.collect.Lists;

import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum DgsTypeEnum implements EnumType{

    QUERY(1, "Query"),
    MUTATION(2, "Mutation"),
    SUBSCRIPTION (3, "Subscription"),
    SCALAR_TYPE(4, "ScalarType"),
    DIRECTIVE(5, "Directive"),
    INPUT(6, "Input(Object)"),
    ENTITY(10, "Entity(Object)");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<DgsTypeEnum> {

        @Override
        public List<DgsTypeEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();
        }
    }
}
