package com.spring.boxes.dollar.enums;

import com.baomidou.mybatisplus.annotation.IEnum;
import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

@AllArgsConstructor
public enum EducationEnum implements EnumType, IEnum<Integer> {

    SECRET(1, "保密"), COLLEGE(2, "大专及以下"), BACHELOR(3, "本科"), MASTER(4, "硕士"), DOCTOR(5, "博士"), OTHER(6, "其它");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<EducationEnum> {

        @Override
        public List<EducationEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();
        }
    }
}
