package com.spring.boxes.dollar.enums;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

@AllArgsConstructor
public enum EffectTypeEnum implements EnumType {

    PERMANENT(1, "永久的"),
    TEMPORARY(3, "临时的");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<EffectTypeEnum> {

        @Override
        public List<EffectTypeEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static Opt INSTANCE() {

            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();
        }

    }
}
