package com.spring.boxes.dollar.enums;

import com.baomidou.mybatisplus.annotation.IEnum;
import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

@AllArgsConstructor
public enum EnableEnum implements EnumType, IEnum<Integer> {

    ENABLED(1, "有效"), DISABLE(3, "无效");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    /**
     * 如果想使用内置通用扩展组件,建议如下实现, 因为枚举的values()是通过编译器实现的,
     * 所以枚举元素集合只能通过枚举本身来透传数值, 这里强烈建议使用单例类,否则每次有新创建对象开销
     */
    public static class Opt extends EnumWrap<EnableEnum> {

        @Override
        public List<EnableEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();
        }

    }
}
