package com.spring.boxes.dollar.enums;

import com.baomidou.mybatisplus.annotation.IEnum;
import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

@Getter
@AllArgsConstructor
public enum FetchTypeEnum implements EnumType, IEnum<Integer> {

    JAVA_EXECUTOR_BEAN(1, "主进程内的Bean(bean名#方法名)"),
    JAVA_STANDARD_CLASS(2, "标准JAVA类方法(包名.类目#方法名)");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<FetchTypeEnum> {

        @Override
        public List<FetchTypeEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();
        }
    }
}
