package com.spring.boxes.dollar.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * ISO_3166-1 世界各国和地区名称代码。列表中国家或地区并不一定具有主权(eg.香港)或不属于任何国家(eg.南极洲)
 * http://zh.wikipedia.org/zh/ISO_3166-1
 */
@Getter
@AllArgsConstructor
public enum ForeignCountry {

    AND("安道尔", "Andorra"),
    ARE("阿联酋", "United Arab Emirates"),
    AFG("阿富汗", "Afghanistan"),
    ATG("安提瓜和巴布达", "Antigua and Barbuda"),
    AIA("安圭拉", "Anguilla"),
    ALB("阿尔巴尼亚", "Albania"),
    ARM("亚美尼亚", "Armenia"),
    AGO("安哥拉", "Angola"),
    ATA("南极洲", "Antarctica"),
    ARG("阿根廷", "Argentina"),
    ASM("美属萨摩亚", "American Samoa"),
    AUT("奥地利", "Austria"),
    AUS("澳大利亚", "Australia"),
    ABW("阿鲁巴", "Aruba"),
    ALA("奥兰群岛", "Åland Islands"),
    AZE("阿塞拜疆", "Azerbaijan"),
    BIH("波斯尼亚和黑塞哥维那", "Bosnia and Herzegovina"),
    BRB("巴巴多斯", "Barbados"),
    BGD("孟加拉国", "Bangladesh"),
    BEL("比利时", "Belgium"),
    BFA("布基纳法索", "Burkina Faso"),
    BGR("保加利亚", "Bulgaria"),
    BHR("巴林", "Bahrain"),
    BDI("布隆迪", "Burundi"),
    BEN("贝宁", "Benin"),
    BLM("圣巴泰勒米岛", "Saint Barthélemy"),
    BMU("百慕大", "Bermuda"),
    BRN("文莱", "Brunei Darussalam"),
    BOL("玻利维亚", "Bolivia (Plurinational State of)"),
    BES("荷兰加勒比区", "Bonaire, Sint Eustatius and Saba"),
    BRA("巴西", "Brazil"),
    BHS("巴哈马", "Bahamas"),
    BTN("不丹", "Bhutan"),
    BVT("布韦岛", "Bouvet Island"),
    BWA("博茨瓦纳", "Botswana"),
    BLR("白俄罗斯", "Belarus"),
    BLZ("伯利兹", "Belize"),
    CAN("加拿大", "Canada"),
    CCK("科科斯群岛", "Cocos (Keeling) Islands"),
    COD("刚果（金）", "Congo (Democratic Republic of the)"),
    CAF("中非", "Central African Republic"),
    COG("刚果（布）", "Congo"),
    CHE("瑞士", "Switzerland"),
    CIV("科特迪瓦", "Côte d'Ivoire"),
    COK("库克群岛", "Cook Islands"),
    CHL("智利", "Chile"),
    CMR("喀麦隆", "Cameroon"),
    CHN("中国", "China"),
    COL("哥伦比亚", "Colombia"),
    CRI("哥斯达黎加", "Costa Rica"),
    CUB("古巴", "Cuba"),
    CPV("佛得角", "Cabo Verde"),
    CUW("库拉索", "Curaçao"),
    CXR("圣诞岛", "Christmas Island"),
    CYP("塞浦路斯", "Cyprus"),
    CZE("捷克", "Czechia"),
    DEU("德国", "Germany"),
    DJI("吉布提", "Djibouti"),
    DNK("丹麦", "Denmark"),
    DMA("多米尼克", "Dominica"),
    DOM("多米尼加", "Dominican Republic"),
    DZA("阿尔及利亚", "Algeria"),
    ECU("厄瓜多尔", "Ecuador"),
    EST("爱沙尼亚", "Estonia"),
    EGY("埃及", "Egypt"),
    ESH("西撒哈拉", "Western Sahara"),
    ERI("厄立特里亚", "Eritrea"),
    ESP("西班牙", "Spain"),
    ETH("埃塞俄比亚", "Ethiopia"),
    FIN("芬兰", "Finland"),
    FJI("斐济群岛", "Fiji"),
    FLK("马尔维纳斯群岛", "Falkland Islands (Malvinas)"),
    FSM("密克罗尼西亚联邦", "Micronesia (Federated States of)"),
    FRO("法罗群岛", "Faroe Islands"),
    FRA("法国", "France"),
    GAB("加蓬", "Gabon"),
    GBR("英国", "United Kingdom of Great Britain and Northern Ireland"),
    GRD("格林纳达", "Grenada"),
    GEO("格鲁吉亚", "Georgia"),
    GUF("法属圭亚那", "French Guiana"),
    GGY("根西岛", "Guernsey"),
    GHA("加纳", "Ghana"),
    GIB("直布罗陀", "Gibraltar"),
    GRL("格陵兰", "Greenland"),
    GMB("冈比亚", "Gambia"),
    GIN("几内亚", "Guinea"),
    GLP("瓜德罗普", "Guadeloupe"),
    GNQ("赤道几内亚", "Equatorial Guinea"),
    GRC("希腊", "Greece"),
    SGS("南乔治亚岛和南桑威奇群岛", "South Georgia and the South Sandwich Islands"),
    GTM("危地马拉", "Guatemala"),
    GUM("关岛", "Guam"),
    GNB("几内亚比绍", "Guinea-Bissau"),
    GUY("圭亚那", "Guyana"),
    HKG("香港", "Hong Kong"),
    HMD("赫德岛和麦克唐纳群岛", "Heard Island and McDonald Islands"),
    HND("洪都拉斯", "Honduras"),
    HRV("克罗地亚", "Croatia"),
    HTI("海地", "Haiti"),
    HUN("匈牙利", "Hungary"),
    IDN("印度尼西亚", "Indonesia"),
    IRL("爱尔兰", "Ireland"),
    ISR("以色列", "Israel"),
    IMN("马恩岛", "Isle of Man"),
    IND("印度", "India"),
    IOT("英属印度洋领地", "British Indian Ocean Territory"),
    IRQ("伊拉克", "Iraq"),
    IRN("伊朗", "Iran (Islamic Republic of)"),
    ISL("冰岛", "Iceland"),
    ITA("意大利", "Italy"),
    JEY("泽西岛", "Jersey"),
    JAM("牙买加", "Jamaica"),
    JOR("约旦", "Jordan"),
    JPN("日本", "Japan"),
    KEN("肯尼亚", "Kenya"),
    KGZ("吉尔吉斯斯坦", "Kyrgyzstan"),
    KHM("柬埔寨", "Cambodia"),
    KIR("基里巴斯", "Kiribati"),
    COM("科摩罗", "Comoros"),
    KNA("圣基茨和尼维斯", "Saint Kitts and Nevis"),
    PRK("朝鲜", "Korea (Democratic People's Republic of)"),
    KOR("韩国", "Korea (Republic of)"),
    KWT("科威特", "Kuwait"),
    CYM("开曼群岛", "Cayman Islands"),
    KAZ("哈萨克斯坦", "Kazakhstan"),
    LAO("老挝", "Lao People's Democratic Republic"),
    LBN("黎巴嫩", "Lebanon"),
    LCA("圣卢西亚", "Saint Lucia"),
    LIE("列支敦士登", "Liechtenstein"),
    LKA("斯里兰卡", "Sri Lanka"),
    LBR("利比里亚", "Liberia"),
    LSO("莱索托", "Lesotho"),
    LTU("立陶宛", "Lithuania"),
    LUX("卢森堡", "Luxembourg"),
    LVA("拉脱维亚", "Latvia"),
    LBY("利比亚", "Libya"),
    MAR("摩洛哥", "Morocco"),
    MCO("摩纳哥", "Monaco"),
    MDA("摩尔多瓦", "Moldova (Republic of)"),
    MNE("黑山", "Montenegro"),
    MAF("法属圣马丁", "Saint Martin (French part)"),
    MDG("马达加斯加", "Madagascar"),
    MHL("马绍尔群岛", "Marshall Islands"),
    MKD("马其顿", "North Macedonia"),
    MLI("马里", "Mali"),
    MMR("缅甸", "Myanmar"),
    MNG("蒙古", "Mongolia"),
    MAC("澳门", "Macao"),
    MNP("北马里亚纳群岛", "Northern Mariana Islands"),
    MTQ("马提尼克", "Martinique"),
    MRT("毛里塔尼亚", "Mauritania"),
    MSR("蒙塞拉特岛", "Montserrat"),
    MLT("马耳他", "Malta"),
    MUS("毛里求斯", "Mauritius"),
    MDV("马尔代夫", "Maldives"),
    MWI("马拉维", "Malawi"),
    MEX("墨西哥", "Mexico"),
    MYS("马来西亚", "Malaysia"),
    MOZ("莫桑比克", "Mozambique"),
    NAM("纳米比亚", "Namibia"),
    NCL("新喀里多尼亚", "New Caledonia"),
    NER("尼日尔", "Niger"),
    NFK("诺福克岛", "Norfolk Island"),
    NGA("尼日利亚", "Nigeria"),
    NIC("尼加拉瓜", "Nicaragua"),
    NKR("纳戈尔诺-卡拉巴赫", "Nagorno Karabakh"),
    NLD("荷兰", "Netherlands"),
    NOR("挪威", "Norway"),
    NPL("尼泊尔", "Nepal"),
    NRU("瑙鲁", "Nauru"),
    NIU("纽埃", "Niue"),
    NZL("新西兰", "New Zealand"),
    OMN("阿曼", "Oman"),
    PAN("巴拿马", "Panama"),
    PER("秘鲁", "Peru"),
    PYF("法属波利尼西亚", "French Polynesia"),
    PNG("巴布亚新几内亚", "Papua New Guinea"),
    PHL("菲律宾", "Philippines"),
    PAK("巴基斯坦", "Pakistan"),
    POL("波兰", "Poland"),
    SPM("圣皮埃尔和密克隆", "Saint Pierre and Miquelon"),
    PCN("皮特凯恩群岛", "Pitcairn"),
    PRI("波多黎各", "Puerto Rico"),
    PSE("巴勒斯坦", "Palestine, State of"),
    PRT("葡萄牙", "Portugal"),
    PLW("帕劳", "Palau"),
    PRY("巴拉圭", "Paraguay"),
    QAT("卡塔尔", "Qatar"),
    REU("留尼汪", "Réunion"),
    ROU("罗马尼亚", "Romania"),
    SRB("塞尔维亚", "Serbia"),
    RUS("俄罗斯", "Russian Federation"),
    RWA("卢旺达", "Rwanda"),
    SAU("沙特阿拉伯", "Saudi Arabia"),
    SLB("所罗门群岛", "Solomon Islands"),
    SYC("塞舌尔", "Seychelles"),
    SDN("苏丹", "Sudan"),
    SWE("瑞典", "Sweden"),
    SGP("新加坡", "Singapore"),
    SHN("圣赫勒拿", "Saint Helena, Ascension and Tristan da Cunha"),
    SVN("斯洛文尼亚", "Slovenia"),
    SJM("斯瓦尔巴群岛和扬马延岛", "Svalbard and Jan Mayen"),
    SVK("斯洛伐克", "Slovakia"),
    SLE("塞拉利昂", "Sierra Leone"),
    SMR("圣马力诺", "San Marino"),
    SEN("塞内加尔", "Senegal"),
    SOM("索马里", "Somalia"),
    SUR("苏里南", "Suriname"),
    SSD("南苏丹", "South Sudan"),
    STP("圣多美和普林西比", "Sao Tome and Principe"),
    SLV("萨尔瓦多", "El Salvador"),
    SXM("荷属圣马丁", "Sint Maarten (Dutch part)"),
    SYR("叙利亚", "Syrian Arab Republic"),
    SWZ("斯威士兰", "Eswatini"),
    TCA("特克斯和凯科斯群岛", "Turks and Caicos Islands"),
    TCD("乍得", "Chad"),
    ATF("法属南部领地", "French Southern Territories"),
    TGO("多哥", "Togo"),
    THA("泰国", "Thailand"),
    TJK("塔吉克斯坦", "Tajikistan"),
    TKL("托克劳", "Tokelau"),
    TLS("东帝汶", "Timor-Leste"),
    TKM("土库曼斯坦", "Turkmenistan"),
    TUN("突尼斯", "Tunisia"),
    TON("汤加", "Tonga"),
    TUR("土耳其", "Turkey"),
    TTO("特立尼达和多巴哥", "Trinidad and Tobago"),
    TUV("图瓦卢", "Tuvalu"),
    TWN("台湾", "Taiwan, Province of China"),
    TZA("坦桑尼亚", "Tanzania, United Republic of"),
    UKR("乌克兰", "Ukraine"),
    UGA("乌干达", "Uganda"),
    UMI("美国本土外小岛屿", "United States Minor Outlying Islands"),
    USA("美国", "United States of America"),
    URY("乌拉圭", "Uruguay"),
    UZB("乌兹别克斯坦", "Uzbekistan"),
    VAT("梵蒂冈", "Holy See"),
    VCT("圣文森特和格林纳丁斯", "Saint Vincent and the Grenadines"),
    VEN("委内瑞拉", "Venezuela (Bolivarian Republic of)"),
    VGB("英属维尔京群岛", "Virgin Islands (British)"),
    VIR("美属维尔京群岛", "Virgin Islands (U.S.)"),
    VNM("越南", "Viet Nam"),
    VUT("瓦努阿图", "Vanuatu"),
    WLF("瓦利斯和富图纳", "Wallis and Futuna"),
    WSM("萨摩亚", "Samoa"),
    YEM("也门", "Yemen"),
    MYT("马约特", "Mayotte"),
    ZAF("南非", "South Africa"),
    ZMB("赞比亚", "Zambia"),
    ZWE("津巴布韦", "Zimbabwe");


    private final String chineseName;
    private final String englishName;
}
