package com.spring.boxes.dollar.enums;

import java.util.List;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;

import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@AllArgsConstructor
public enum GratuityTypeEnum implements EnumType {

    PRESENT(1, "礼物"),
    MONEY(2, "钱币");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @NoArgsConstructor
    public static class Opt extends EnumWrap<GratuityTypeEnum> {

        public List<GratuityTypeEnum> valueList() {
            return Lists.newArrayList(GratuityTypeEnum.values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();

            private SingleHold() {
            }
        }
    }

}
