package com.spring.boxes.dollar.enums;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum HashTypeEnum {

    MD5("MD5", Hashing.md5()), SHA_1("SHA-1", Hashing.sha1()), SHA_256("SHA-256", Hashing.sha256()), MURMUR3_128("MURMUR3_128", Hashing.murmur3_128());

    private final String label;

    private final HashFunction function;

    public static HashTypeEnum getHashType(String name) {
        if (HashTypeEnum.MD5.getLabel().equalsIgnoreCase(name)) {
            return HashTypeEnum.MD5;
        }
        if (HashTypeEnum.SHA_1.getLabel().equalsIgnoreCase(name)) {
            return HashTypeEnum.SHA_1;
        }
        if (HashTypeEnum.SHA_256.getLabel().equalsIgnoreCase(name)) {
            return HashTypeEnum.SHA_256;
        }
        if (HashTypeEnum.MURMUR3_128.getLabel().equalsIgnoreCase(name)) {
            return HashTypeEnum.MURMUR3_128;
        }
        return HashTypeEnum.MURMUR3_128;
    }

    public static HashFunction getHashFunction(HashTypeEnum hashEnum) {
        if (HashTypeEnum.MD5 == hashEnum) {
            return HashTypeEnum.MD5.getFunction();
        }
        if (HashTypeEnum.SHA_1 == hashEnum) {
            return HashTypeEnum.SHA_1.getFunction();
        }
        if (HashTypeEnum.SHA_256 == hashEnum) {
            return HashTypeEnum.SHA_256.getFunction();
        }
        if (HashTypeEnum.MURMUR3_128 == hashEnum) {
            return HashTypeEnum.MURMUR3_128.getFunction();
        }
        return HashTypeEnum.MURMUR3_128.getFunction();
    }
}
