/*--------------------------------------------------------------------------
 *  Copyright (c) 2010-2020, Elon.su All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the elon developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: Elon.su, you can also mail dennisit@163.com
 *--------------------------------------------------------------------------
 */
package com.spring.boxes.dollar.enums;

import com.baomidou.mybatisplus.annotation.IEnum;
import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

@Getter
@AllArgsConstructor
public enum InjectTypeEnum implements EnumType, IEnum<Integer> {

    PLAT_ALLOT(1, "系统分配"),
    SIGN_EMAIL(3, "邮箱注册"),
    SIGN_PHONE(5, "手机注册"),
    SOCIAL_WECHAT(7, "微信"),
    SOCIAL_WECHAT_MINI_APP(9, "微信小程序"),
    SOCIAL_WECHAT_MP(11, "微信公众号"),
    SOCIAL_WEIBO(13, "微博"),
    SOCIAL_QQ(15, "QQ"),
    SOCIAL_GIT_HUB(17, "Github"),
    SOCIAL_GIT_EE(19, "Gitee"),
    SOCIAL_OS_CHINA(21, "开源中国"),
    SOCIAL_CODING(23, "Coding"),
    SOCIAL_TENCENT_CLOUD(25, "腾讯云"),
    SOCIAL_ALI_PAY(27, "支付宝"),
    SOCIAL_CSDN(29, "CSDN"),
    SOCIAL_TAO_BAO(31, "淘宝"),
    SOCIAL_BAI_DU(33, "百度"),
    SOCIAL_DING_TALK(35, "钉钉"),
    SOCIAL_GOOGLE(37, "谷歌"),
    SOCIAL_MICROSOFT(39, "微软"),
    SOCIAL_FACEBOOK(41, "Facebook"),
    SOCIAL_LINKEDIN(43, "领英"),
    SOCIAL_DOU_YIN(45, "抖音"),
    SOCIAL_MI(47, "小米"),
    SOCIAL_TOUTIAO(49, "头条"),
    SOCIAL_TEAMBITION(51, "Teambition"),
    SOCIAL_PINTEREST(53, "Pinterest"),
    SOCIAL_RENREN(57, "人人网"),
    SOCIAL_STACK_OVERFLOW(59, "StackOverflow"),
    SOCIAL_HUAWEI(61, "华为"),
    SOCIAL_WECHAT_ENTERPRISE(63, "企业微信"),
    SOCIAL_KUJIALE(65, "酷家乐"),
    SOCIAL_GITLAB(67, "Gitlab"),
    SOCIAL_MEITUAN(69, "美团"),
    SOCIAL_ELEME(71, "饿了么");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<InjectTypeEnum> {

        @Override
        public List<InjectTypeEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();
        }

    }

}
