package com.spring.boxes.dollar.enums;

import com.baomidou.mybatisplus.annotation.IEnum;
import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

// 积分消耗场景
@Getter
@AllArgsConstructor
public enum IntegralSceneEnum implements EnumType, IEnum<Integer> {

    PUNCH_INTEGRAL(1, "每日签到", TradeTypeEnum.INCOME),
    PAYMENT_OBTAIN(2, "支付购买", TradeTypeEnum.INCOME),
    ADVERT_GRATUITY(3, "广告奖励", TradeTypeEnum.INCOME),

    PEOPLE_REGISTRY(4, "新人注册", TradeTypeEnum.INCOME),

    GRANT_PRESENT(21, "礼物赠送", TradeTypeEnum.EXPEND),
    SHINY_PUBLISH(22, "发送闪照", TradeTypeEnum.EXPEND),
    BLIND_BOTTLE(23, "盲盒抽取", TradeTypeEnum.EXPEND);

    private final int value;
    private final String label;

    private final TradeTypeEnum tradeType;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<IntegralSceneEnum> {

        @Override
        public List<IntegralSceneEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();
        }
    }
}
