package com.spring.boxes.dollar.enums;

import com.baomidou.mybatisplus.annotation.IEnum;
import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

@Getter
@AllArgsConstructor
public enum InvestTypeEnum implements EnumType, IEnum<Integer> {

    INVEST1(1, "未融资"),
    INVEST2(3, "天使轮"),
    INVEST3(5, "A轮"),
    INVEST4(7, "B轮"),
    INVEST5(9, "C轮"),
    INVEST6(11, "D轮已以上"),
    INVEST7(13, "已上市"),
    INVEST8(15, "不需要融资");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<InvestTypeEnum> {


        @Override
        public List<InvestTypeEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();
        }
    }

}
