package com.spring.boxes.dollar.enums;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

@Getter
@AllArgsConstructor
public enum MemberTypeEnum implements EnumType {

    GROUP_USER(1, "社交好友分组"),
    GROUP_CHAT(3, "社交聊天群组"),
    PLATE_USER(5, "话题区管理员");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<MemberTypeEnum> {

        public Opt() {
        }

        public List<MemberTypeEnum> valueList() {
            return Lists.newArrayList(MemberTypeEnum.values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();

            private SingleHold() {

            }
        }
    }
}
