package com.spring.boxes.dollar.enums;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

@Getter
@AllArgsConstructor
public enum MetaTypeEnum implements EnumType {

    TEXT(1, "文本消息"), IMAGE(2, "图片消息"), FILE(3, "文件消息"), VIDEO(4, "视频消息"), AUDIO(5, "音频消息");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<MetaTypeEnum> {

        @Override
        public List<MetaTypeEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static MetaTypeEnum.Opt INSTANCE() {
            return MetaTypeEnum.Opt.SingleHold.opt;
        }

        private static class SingleHold {
            public static MetaTypeEnum.Opt opt = new MetaTypeEnum.Opt();
        }
    }
}
