/*--------------------------------------------------------------------------
 *  Copyright (c) 2010-2020, Elon.su All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the elon developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: Elon.su, you can also mail dennisit@163.com
 *--------------------------------------------------------------------------
 */
package com.spring.boxes.dollar.enums;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;

import java.util.List;

@AllArgsConstructor
public enum MonthWageEnum implements EnumType {

    SECRET(1, "保密"), MK0_2(2, "2k以下"), MK2_5(3, "2k-5k"), MK5_10(4, "5k-10k"), MK10_15(5, "10k-15k"), MK15_25(6, "15k-25k"), MK25_50(7, "25k-50k"), MK50_OVER(8, "50k以上");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<MonthWageEnum> {

        @Override
        public List<MonthWageEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();
        }
    }
}
