package com.spring.boxes.dollar.enums;

import java.util.List;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;

import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@AllArgsConstructor
public enum OrderStatusEnum implements EnumType {

    CREATED(1, "待支付"),
    PAID(2, "已支付"),
    CANCEL(3, "已取消"),
    DELIVERY(4, "待发货"),
    DELIVERED(5, "已发货"),
    RECEIVED(6, "已收货"),
    DELETED(7, "已删除");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @NoArgsConstructor
    public static class Opt extends EnumWrap<OrderStatusEnum> {

        public List<OrderStatusEnum> valueList() {
            return Lists.newArrayList(OrderStatusEnum.values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();

            private SingleHold() {
            }
        }
    }


}
