package com.spring.boxes.dollar.enums;

import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;

@Getter
@AllArgsConstructor
public enum OssTypeEnum implements EnumType {

    LOCAL(1, "本机OS"),
    MINIO(2, "MINIO"),
    QINIU(3, "七牛云"),
    QCLOUD(4, "腾讯云"),
    ALIYUN(5, "阿里云");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static OssTypeEnum valueGet(int value) {
        return Arrays.stream(OssTypeEnum.values())
                .filter(e -> e.getValue() == value)
                .findFirst()
                .orElse(null);
    }

    public static class Opt extends EnumWrap<OssTypeEnum> {

        @Override
        public List<OssTypeEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();
        }
    }
}
