package com.spring.boxes.dollar.enums;

import java.util.List;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum PaySceneEnum implements EnumType {

    WALLET_INCOME(1,"钱包充值"),
    MEMBER_RECHARGE(2, "会员充值"),
    PRESENT_GRATUITY(3, "礼物打赏"),
    ENERGY_BUY(4, "能量购买"),
    INTEGRAL_BUY(5, "金币充值");

    @EnumValue
    @JsonValue
    private final Integer value;
    private final String label;

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name();
    }

    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<PaySceneEnum> {

        public List<PaySceneEnum> valueList() {
            return Lists.newArrayList(PaySceneEnum.values());
        }

        public static Opt INSTANCE() {
            return PaySceneEnum.Opt.SingleHold.opt;
        }

        public Opt() {
        }

        private static class SingleHold {
            public static Opt opt = new Opt();

            private SingleHold() {
            }
        }
    }
}
