package com.spring.boxes.dollar.enums;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.ApiResult;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

@Getter
@AllArgsConstructor
public enum PayStatusEnum implements EnumType {


    NOT_PAYMENT(1, "无需支付"),
    PAY_WAITING(2, "等待支付"),
    PAY_SUCCESS(3, "支付完成"),
    PAY_FAILURE(4, "支付失败"),
    PAY_CANCELED(5, "支付取消");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<PayStatusEnum> {

        public List<PayStatusEnum> valueList() {
            return Lists.newArrayList(PayStatusEnum.values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();

            private SingleHold() {

            }
        }
    }
}
