package com.spring.boxes.dollar.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

@Getter
@AllArgsConstructor
public enum PunchSceneEnum implements EnumType {

    INCOME_PUNCH(1,"签到奖励积分"),
    DEDUCT_BOTTLE(11, "抽取盲盒消费积分");

    @EnumValue
    @JsonValue
    private final Integer value;
    private final String label;

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name();
    }

    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<PunchSceneEnum> {

        public List<PunchSceneEnum> valueList() {
            return Lists.newArrayList(PunchSceneEnum.values());
        }

        public static Opt INSTANCE() {
            return PunchSceneEnum.Opt.SingleHold.opt;
        }

        public Opt() {
        }

        private static class SingleHold {
            public static Opt opt = new Opt();

            private SingleHold() {
            }
        }
    }
}
