package com.spring.boxes.dollar.enums;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;

import java.util.List;

@AllArgsConstructor
public enum PushStateEnum implements EnumType{

    WAITING(1, "待处理"),
    SUCCESS(3, "成功"),
    FAILURE(5, "失败");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<PushStateEnum> {

        @Override
        public List<PushStateEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static PushStateEnum.Opt INSTANCE() {
            return PushStateEnum.Opt.SingleHold.opt;
        }

        private static class SingleHold {
            public static PushStateEnum.Opt opt = new PushStateEnum.Opt();
        }
    }
}
