package com.spring.boxes.dollar.enums;

import java.util.List;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;

import lombok.AllArgsConstructor;

@AllArgsConstructor
public enum RelationItemEnum implements EnumType {

    MOMENT(1, "动态"), COMMENT(3, "评论"),
    ARTICLE(5, "文章"), DATUM(7, "资讯"),
    PLATE(8, "版块"), TOPIC(9, "话题"),
    ACTIVITY(11, "活动"),
    COMPANY(21, "企业"), RECRUIT(23, "职位"), RESUME(25, "简历"), PREACH(27, "宣讲"),
    MERCHANT(31, "商家"), PRODUCT(33, "商品");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<RelationItemEnum> {

        public List<RelationItemEnum> valueList() {
            return Lists.newArrayList(RelationItemEnum.values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        public Opt() {
        }

        private static class SingleHold {
            public static Opt opt = new Opt();

            private SingleHold() {
            }
        }
    }
}
