package com.spring.boxes.dollar.enums;

import java.util.List;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;

import lombok.AllArgsConstructor;

@AllArgsConstructor
public enum RelationTypeEnum implements EnumType {

    FAVORITE(1, "收藏"), SUPPORT(3, "点赞"), OPPOSE(5, "反对"), MENTION(7, "预约"),
    VISITOR(7, "浏览"), SHARE(9, "分享");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<RelationTypeEnum> {

        public List<RelationTypeEnum> valueList() {
            return Lists.newArrayList(RelationTypeEnum.values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        public Opt() {
        }

        private static class SingleHold {
            public static Opt opt = new Opt();

            private SingleHold() {
            }
        }
    }
}
