package com.spring.boxes.dollar.enums;

import java.util.List;

import com.baomidou.mybatisplus.annotation.IEnum;
import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum SourceEnum implements EnumType, IEnum<Integer> {

    GOOGLE(1, "谷歌", "https://www.google.com/"),
    BAIDU(2, "百度", "https://www.baidu.com/");

    private final int value;
    private final String label;
    private final String link;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<SourceEnum> {

        @Override
        public List<SourceEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();
        }
    }
}
