package com.spring.boxes.dollar.enums;

import java.util.List;

import com.baomidou.mybatisplus.annotation.IEnum;
import com.google.common.collect.Lists;

import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum TempletTypeEnum implements EnumType, IEnum<Integer> {

    EMAIL(1, "模板—邮件"),
    SMS(3, "模板-短信"),
    NOTIFY(5, "模板-站内信");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<TempletTypeEnum> {

        @Override
        public List<TempletTypeEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static TempletTypeEnum.Opt INSTANCE() {
            return TempletTypeEnum.Opt.SingleHold.opt;
        }

        private static class SingleHold {
            public static TempletTypeEnum.Opt opt = new TempletTypeEnum.Opt();
        }
    }
}
