package com.spring.boxes.dollar.enums;

import java.util.List;

import com.baomidou.mybatisplus.annotation.IEnum;
import com.google.common.collect.Lists;

import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum ThrowTypeEnum implements EnumType, IEnum<Integer> {

    PUSH(1, "推送"),
    DATA(3, "数据");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<ThrowTypeEnum> {

        @Override
        public List<ThrowTypeEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static ThrowTypeEnum.Opt INSTANCE() {
            return ThrowTypeEnum.Opt.SingleHold.opt;
        }

        private static class SingleHold {
            public static ThrowTypeEnum.Opt opt = new ThrowTypeEnum.Opt();
        }
    }
}
