package com.spring.boxes.dollar.enums;

import java.util.List;

import com.baomidou.mybatisplus.annotation.IEnum;
import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum TimePeriodEnum implements EnumType, IEnum<Integer>{

    DAY(1, "天"), MONTH(5, "月"), WEEK(3, "周"), YEAR(7, "年");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<TimePeriodEnum> {

        public List<TimePeriodEnum> valueList() {
            return Lists.newArrayList(TimePeriodEnum.values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();
        }
    }
}
