package com.spring.boxes.dollar.enums;

import com.baomidou.mybatisplus.annotation.IEnum;
import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

@Getter
@AllArgsConstructor
public enum UserAscribeEnum implements EnumType, IEnum<Integer> {

    NOW_USER_SELF(1, "发起用户"),
    NEW_USER_HELP(3, "新客助力"),
    OLD_USER_HELP(7, "老客助力"),
    OLD_USER_EVOKE(5, "老客唤起");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<UserAscribeEnum> {

        public Opt() { }

        public List<UserAscribeEnum> valueList() {
            return Lists.newArrayList(UserAscribeEnum.values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();
            private SingleHold() { }
        }
    }
}
