package com.spring.boxes.dollar.enums;

import com.baomidou.mybatisplus.annotation.IEnum;
import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

@Getter
@AllArgsConstructor
public enum UserScaleEnum implements EnumType, IEnum<Integer>{

    USER_OTHER(1, "不限制"),
    USER_0_20(3, "0-20人"),
    USER_20_99(5, "20-99人"),
    USER_100_499(7, "100-499人"),
    USER_500_999(9, "500-999人"),
    USER_1000_9999(11, "1000-9999人"),
    USER_MORE_10000(13, "10000人以上");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<UserScaleEnum> {

        @Override
        public List<UserScaleEnum> valueList() {
            return Lists.newArrayList(values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();
        }
    }
}
