package com.spring.boxes.dollar.enums;

import java.util.List;

import com.google.common.collect.Lists;
import com.spring.boxes.dollar.support.EnumType;
import com.spring.boxes.dollar.support.EnumWrap;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum VenueThrowType implements EnumType {

    TIME_LIMITED(1, "限制时间"), TIME_IGNORE(2, "忽略时间限制");

    private final int value;
    private final String label;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static class Opt extends EnumWrap<VenueThrowType> {

        public Opt() { }

        public List<VenueThrowType> valueList() {
            return Lists.newArrayList(VenueThrowType.values());
        }

        public static Opt INSTANCE() {
            return SingleHold.opt;
        }

        private static class SingleHold {
            public static Opt opt = new Opt();

            private SingleHold() {

            }
        }
    }
}
